/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpBrokenContentException;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;

public final class ChunkedTransferEncoding
implements TransferEncoding {
    private static final int MAX_HTTP_CHUNK_SIZE_LENGTH = 16;
    private static final long CHUNK_SIZE_OVERFLOW = 0x7FFFFFFFFFFFFFFL;
    private static final int CHUNK_LENGTH_PARSED_STATE = 3;
    private static final byte[] LAST_CHUNK_CRLF_BYTES = "0\r\n".getBytes(Charsets.ASCII_CHARSET);
    private static final int[] DEC = HexUtils.getDecBytes();
    private final int maxHeadersSize;

    public ChunkedTransferEncoding(int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
    }

    @Override
    public boolean wantDecode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public boolean wantEncode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public void prepareSerialize(FilterChainContext ctx, HttpHeader httpHeader, HttpContent content) {
        httpHeader.makeTransferEncodingHeader("chunked");
    }

    @Override
    public ParsingResult parsePacket(FilterChainContext ctx, HttpHeader httpPacket, Buffer buffer) {
        HttpPacketParsing httpPacketParsing = (HttpPacketParsing)((Object)httpPacket);
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacketParsing.getContentParsingState();
        boolean isLastChunk = contentParsingState.isLastChunk;
        if (!isLastChunk && contentParsingState.chunkRemainder <= 0L) {
            if ((buffer = ChunkedTransferEncoding.parseTrailerCRLF(httpPacketParsing, buffer)) == null) {
                return ParsingResult.create(null, null);
            }
            if (!ChunkedTransferEncoding.parseHttpChunkLength(httpPacketParsing, buffer)) {
                if (ChunkedTransferEncoding.isHeadRequest(httpPacket)) {
                    return ParsingResult.create(httpPacket.httpTrailerBuilder().headers(contentParsingState.trailerHeaders).build(), null);
                }
                return ParsingResult.create(null, buffer);
            }
        } else {
            contentParsingState.chunkContentStart = 0;
        }
        int chunkContentStart = contentParsingState.chunkContentStart;
        if (contentParsingState.chunkLength == 0L) {
            if (!isLastChunk) {
                contentParsingState.isLastChunk = true;
                isLastChunk = true;
                this.initTrailerParsing(httpPacketParsing);
            }
            if (!this.parseLastChunkTrailer(ctx, httpPacket, httpPacketParsing, buffer)) {
                return ParsingResult.create(null, buffer);
            }
            chunkContentStart = httpPacketParsing.getHeaderParsingState().offset;
        }
        long thisPacketRemaining = contentParsingState.chunkRemainder;
        int contentAvailable = buffer.limit() - chunkContentStart;
        Buffer remainder = null;
        if ((long)contentAvailable > thisPacketRemaining) {
            remainder = buffer.split((int)((long)chunkContentStart + thisPacketRemaining));
            buffer.position(chunkContentStart);
        } else if (chunkContentStart > 0) {
            buffer.position(chunkContentStart);
        }
        if (isLastChunk) {
            return ParsingResult.create(httpPacket.httpTrailerBuilder().headers(contentParsingState.trailerHeaders).build(), remainder);
        }
        buffer.shrink();
        if (buffer.hasRemaining()) {
            contentParsingState.chunkRemainder -= (long)buffer.remaining();
        } else {
            buffer.tryDispose();
            buffer = Buffers.EMPTY_BUFFER;
        }
        return ParsingResult.create(((HttpContent.Builder)httpPacket.httpContentBuilder().content(buffer)).build(), remainder);
    }

    @Override
    public Buffer serializePacket(FilterChainContext ctx, HttpContent httpContent) {
        return ChunkedTransferEncoding.encodeHttpChunk(ctx.getMemoryManager(), httpContent, httpContent.isLast());
    }

    private void initTrailerParsing(HttpPacketParsing httpPacket) {
        int start;
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        headerParsingState.subState = 0;
        headerParsingState.start = start = contentParsingState.chunkContentStart;
        headerParsingState.offset = start;
        headerParsingState.packetLimit = start + this.maxHeadersSize;
    }

    private boolean parseLastChunkTrailer(FilterChainContext ctx, HttpHeader httpHeader, HttpPacketParsing httpPacket, Buffer input2) {
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        HttpCodecFilter filter2 = headerParsingState.codecFilter;
        boolean result2 = filter2.parseHeadersFromBuffer(httpHeader, contentParsingState.trailerHeaders, headerParsingState, input2);
        if (result2) {
            if (contentParsingState.trailerHeaders.size() > 0) {
                filter2.onHttpHeadersParsed(httpHeader, ctx);
            }
        } else {
            headerParsingState.checkOverflow("The chunked encoding trailer header is too large");
        }
        return result2;
    }

    private static boolean parseHttpChunkLength(HttpPacketParsing httpPacket, Buffer input2) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        while (true) {
            switch (parsingState.state) {
                case 0: {
                    int pos;
                    parsingState.start = pos = input2.position();
                    parsingState.offset = pos;
                    parsingState.packetLimit = pos + 16;
                }
                case 1: {
                    int nonSpaceIdx = HttpCodecUtils.skipSpaces(input2, parsingState.offset, parsingState.packetLimit);
                    if (nonSpaceIdx == -1) {
                        parsingState.offset = input2.limit();
                        parsingState.state = 1;
                        parsingState.checkOverflow("The chunked encoding length prefix is too large");
                        return false;
                    }
                    parsingState.offset = nonSpaceIdx;
                    parsingState.state = 2;
                }
                case 2: {
                    int offset;
                    int limit = Math.min(parsingState.packetLimit, input2.limit());
                    long value2 = parsingState.parsingNumericValue;
                    for (offset = parsingState.offset; offset < limit; ++offset) {
                        byte b = input2.get(offset);
                        if (HttpCodecUtils.isSpaceOrTab(b) || b == 13 || b == 59) {
                            parsingState.checkpoint = offset;
                            continue;
                        }
                        if (b == 10) {
                            HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
                            contentParsingState.chunkContentStart = offset + 1;
                            contentParsingState.chunkLength = value2;
                            contentParsingState.chunkRemainder = value2;
                            parsingState.state = 3;
                            return true;
                        }
                        if (parsingState.checkpoint == -1) {
                            if (DEC[b & 0xFF] != -1 && ChunkedTransferEncoding.checkOverflow(value2)) {
                                value2 = (value2 << 4) + (long)DEC[b & 0xFF];
                                continue;
                            }
                            throw new HttpBrokenContentException("Invalid byte representing a hex value within a chunk length encountered : " + b);
                        }
                        throw new HttpBrokenContentException("Unexpected HTTP chunk header");
                    }
                    parsingState.parsingNumericValue = value2;
                    parsingState.offset = offset;
                    parsingState.checkOverflow("The chunked encoding length prefix is too large");
                    return false;
                }
            }
        }
    }

    private static boolean checkOverflow(long value2) {
        return value2 <= 0x7FFFFFFFFFFFFFFL;
    }

    private static boolean isHeadRequest(HttpHeader header) {
        HttpRequestPacket request = header.isRequest() ? (HttpRequestPacket)header : ((HttpResponsePacket)header).getRequest();
        return request.isHeadRequest();
    }

    private static Buffer parseTrailerCRLF(HttpPacketParsing httpPacket, Buffer input2) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        if (parsingState.state == 3) {
            while (input2.hasRemaining()) {
                if (input2.get() != 10) continue;
                parsingState.recycle();
                if (input2.hasRemaining()) {
                    return input2.slice();
                }
                return null;
            }
            return null;
        }
        return input2;
    }

    private static Buffer encodeHttpChunk(MemoryManager memoryManager, HttpContent httpContent, boolean isLastChunk) {
        Object httpChunkTrailer;
        boolean hasContent;
        Buffer content = httpContent.getContent();
        Object httpChunkBuffer = memoryManager.allocate(16);
        int chunkSize = content.remaining();
        Ascii.intToHexString(httpChunkBuffer, chunkSize);
        httpChunkBuffer = HttpCodecUtils.put(memoryManager, httpChunkBuffer, HttpCodecFilter.CRLF_BYTES);
        httpChunkBuffer.trim();
        httpChunkBuffer.allowBufferDispose(true);
        boolean bl = hasContent = chunkSize > 0;
        if (hasContent && (httpChunkBuffer = Buffers.appendBuffers(memoryManager, (Buffer)httpChunkBuffer, content)).isComposite()) {
            httpChunkBuffer.allowBufferDispose(true);
            ((CompositeBuffer)httpChunkBuffer).allowInternalBuffersDispose(true);
            ((CompositeBuffer)httpChunkBuffer).disposeOrder(CompositeBuffer.DisposeOrder.FIRST_TO_LAST);
        }
        if (!isLastChunk) {
            httpChunkTrailer = memoryManager.allocate(2);
        } else {
            boolean isTrailer = HttpTrailer.isTrailer(httpContent) && ((HttpTrailer)httpContent).getHeaders().size() > 0;
            httpChunkTrailer = !isTrailer ? memoryManager.allocate(8) : memoryManager.allocate(256);
            if (hasContent) {
                httpChunkTrailer = HttpCodecUtils.put(memoryManager, (Buffer)httpChunkTrailer, HttpCodecFilter.CRLF_BYTES);
                httpChunkTrailer = HttpCodecUtils.put(memoryManager, (Buffer)httpChunkTrailer, LAST_CHUNK_CRLF_BYTES);
            }
            if (isTrailer) {
                HttpTrailer httpTrailer = (HttpTrailer)httpContent;
                MimeHeaders mimeHeaders = httpTrailer.getHeaders();
                httpChunkTrailer = HttpCodecFilter.encodeMimeHeaders(memoryManager, (Buffer)httpChunkTrailer, mimeHeaders, httpContent.getHttpHeader().getTempHeaderEncodingBuffer());
            }
        }
        httpChunkTrailer = HttpCodecUtils.put(memoryManager, httpChunkTrailer, HttpCodecFilter.CRLF_BYTES);
        httpChunkTrailer.trim();
        httpChunkTrailer.allowBufferDispose(true);
        return Buffers.appendBuffers(memoryManager, (Buffer)httpChunkBuffer, (Buffer)httpChunkTrailer);
    }
}

